/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.analyse;

import java.io.FileWriter;
import java.io.IOException;

import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

/**
 *
 * @author Utilisateur
 */
public class SacArticles {
    private Map<Integer, Article> listeArticles;
    private String titre;
    private Vector<String> ressources;

    public SacArticles(String titre) {
        this.titre = titre;
        this.listeArticles = new HashMap<Integer, Article>();
        this.ressources = new Vector<String>();
        addRessource(titre);
    }

    public String getTitre() {
        return titre;
    }

    public void setTitre(String titre) {
        this.titre = titre;
    }

    public void addArticle(Article a){
        listeArticles.put(new Integer(a.getId()), a);
    }

    public Article getArticle(int id){
        return listeArticles.get(new Integer(id));
    }

    public void addRessource(String ressource){
        ressources.addElement(ressource);
    }

    public String[] getRessources(){
        String[] res = new String[ressources.size()];
        ressources.toArray(res);
        return res;
    }

    public String[] recycleEnRessources(){
        Vector res0 = (Vector)(ressources.clone());
        for(int i=0; i<getArticles().length; i++){
            String ressource = getArticles()[i].getTitre();
            res0.addElement(ressource);
            ressource = getArticles()[i].getDescription();
            res0.addElement(ressource);
        }
        String[] res = new String[res0.size()];
        res0.toArray(res);
        return res;
    }

    public Article[] getArticles(){
        Article[] res = new Article[listeArticles.values().size()];
        listeArticles.values().toArray(res);
        return res;
    }

    public boolean contientArticle(Article a){
        Article[] liste = getArticles();
        boolean res = false;
        for(int i=0; i<liste.length; i++){
            if(a.equals(liste[i])){
                res = true;
                break;
            }
        }
        return res;
    }

    public void removeArticle(Article a){
        listeArticles.remove(new Integer(a.getId()));
    }

    public void addAll(SacArticles a){
        Article[] liste = a.getArticles();
        for(int i=0; i<liste.length; i++){
            addArticle(liste[i]);
        }
        addRessource(a.titre);
        for(int i=0; i<a.getRessources().length; i++){
            addRessource(a.getRessources()[i]);
        }
    }

    @Override
    public SacArticles clone(){
        SacArticles clone = new SacArticles(titre);
        Article[] aCopier = getArticles();
        for(int i=0; i<aCopier.length; i++){
            clone.addArticle(aCopier[i].clone());
        }
        return clone;
    }

    String getSauvegarde(){
        String s = "<Titre>"+getTitre()+"</Titre>\n";
        Article[] aCopier = getArticles();
        for(int i=0; i<aCopier.length; i++){
            s += "<Article>\n"+aCopier[i].getSauvegarde()+"</Article>\n";
        }
        String[] aCopier2 = getRessources();
        for(int i=0; i<aCopier2.length; i++){
            s += "<Ressource>\n"+aCopier2[i]+"</Ressource>\n";
        }
        return s;
    }

    void sauvegarde(FileWriter out) throws IOException {
        out.write("<Titre>"+getTitre()+"</Titre>\n");
        Article[] aCopier = getArticles();
        for(int i=0; i<aCopier.length; i++){
            out.write("<Article>\n");
            aCopier[i].sauvegarde(out);
            out.write("</Article>\n");
        }
        String[] aCopier2 = getRessources();
        for(int i=0; i<aCopier2.length; i++){
            out.write("<Ressource>\n"+aCopier2[i]+"</Ressource>\n");
        }
    }

    static SacArticles charge(String sauvegarde){
        String s0 = sauvegarde.split("</Titre>")[0];
        s0 = s0.replaceAll("<Titre>", "");
        SacArticles res = new SacArticles(s0);
        String[] s = sauvegarde.split("<Article>");
        for(int i=1; i<s.length; i++){ // index 0 = "<Titre>...</Titre>"
            String save = s[i].substring(0, s[i].indexOf("</Article>")).trim();
            res.addArticle(Article.charge(save));
        }
        String[] s2 = sauvegarde.split("<Ressource>");
        for(int i=1; i<s2.length; i++){ // index 0 = "<Titre>...</Article>"
            String save = s2[i].substring(0, s2[i].indexOf("</Ressource>")).trim();
            res.addRessource(save);
        }
        return res;
    }

    @Override
    public String toString(){
        int g = 0;
        int o = 0;
        int r = 0;
        Article[] a = getArticles();
        for(int i=0; i<a.length; i++){
            if(a[i].getStatut()==Article.VALIDE){
                g++;
            } else if(a[i].getStatut()==Article.SUGGERE){
                r++;
            } else {
                o++;
            }
        }
        String s = "";
        if(g>0){
            s += "<span style=\"color:#00C000\">"+g+"</span>";
        }
        if(g>0 && (o>0 || r>0)){
            s += ", ";
        }
        if(o>0){
            s += "<span style=\"color:#C08000\">"+o+"</span>";
        }
        if(o>0 && r>0){
            s += ", ";
        }
        if(r>0){
            s += "<span style=\"color:#C00000\">"+r+"</span>";
        }
        return "<html>["+s+"] "+titre;
    }
}
